#ifndef EXTRACT_PTS_H_
#define EXTRACT_PTS_H_

#include <string.h>
#include <fstream>
#include <vector>
#include "IOExtraction.h"
#include "Vector3.h"

template <typename T>
void read_pts(const std::string& filename, std::vector<Vector3<T>>& points)
{
	std::ifstream ifile(filename.c_str());
	std::vector<char> leftSkipTokens;
	leftSkipTokens.push_back(' ');
	leftSkipTokens.push_back('\n');
	leftSkipTokens.push_back('\t');
	double value;
	std::vector<char> delimiters;
	delimiters.push_back(' ');
	delimiters.push_back('\n');
	delimiters.push_back('\t');

	// read the number of data (first line)
	if (IOExtract(ifile, leftSkipTokens, value, delimiters))
	{
		std::cout << value << std::endl;
	}

	// read the 3d coordinates (remaining lines)
	while (ifile.good())
	{
		Vector3<T> v;

		// x coord
		if (IOExtract(ifile, leftSkipTokens, value, delimiters))
			//v.x = value;
			v.z = -value;
			//std::cout << value << " ";
		else
			break;

		// y coord
		if (IOExtract(ifile, leftSkipTokens, value, delimiters))
			//v.y = value;
			v.x = value;
			//std::cout << value << " ";
		else
			break;

		// z coord
		if (IOExtract(ifile, leftSkipTokens, value, delimiters))
			//v.z = value;
			v.y = value;
			//std::cout << value << " \n";
		else
			break;

		points.push_back( v );
	}
}

#endif	// EXTRACT_PTS_H_